/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsFal_error.h 59965 2016-03-16 15:54:51Z trieu                       $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         30.05.2012   TD
     Created
*******************************************************************************/
#ifndef __DNS_FAL_ERROR_H
#define __DNS_FAL_ERROR_H

////////////////////////////////////////////////////////////////////////////////
// DeviceNet Slave FAL Task (Fieldbus Application Layer).
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DNS_FAL_DUPLICATE_MAC_ID
//
// MessageText:
//
//  Duplicate MAC ID found.
//
#define TLR_E_DNS_FAL_DUPLICATE_MAC_ID   ((TLR_RESULT)0xC0620001L)

//
// MessageId: TLR_E_DNS_FAL_INIT_TO_LESS_DATA
//
// MessageText:
//
//  To less data for init command.
//
#define TLR_E_DNS_FAL_INIT_TO_LESS_DATA  ((TLR_RESULT)0xC0620002L)

//
// MessageId: TLR_E_DNS_FAL_FUNCTION_NOT_SUPPORTED
//
// MessageText:
//
//  Function not supported.
//
#define TLR_E_DNS_FAL_FUNCTION_NOT_SUPPORTED ((TLR_RESULT)0xC0620003L)

//
// MessageId: TLR_E_DNS_FAL_COMMAND_ALLREADY_IN_REQUEST
//
// MessageText:
//
//  Command allready in request.
//
#define TLR_E_DNS_FAL_COMMAND_ALLREADY_IN_REQUEST ((TLR_RESULT)0xC0620004L)

//
// MessageId: TLR_E_DNS_FAL_PRM_ERR_CODE
//
// MessageText:
//
//  Invalid parameter in Init Stack request.
//
#define TLR_E_DNS_FAL_PRM_ERR_CODE       ((TLR_RESULT)0xC0620006L)

//
// MessageId: TLR_E_DNS_FAL_BAUDRATE_OUT_RANGE
//
// MessageText:
//
//  Invalid Baudrate entered in Init Stack request.
//
#define TLR_E_DNS_FAL_BAUDRATE_OUT_RANGE ((TLR_RESULT)0xC0620007L)

//
// MessageId: TLR_E_DNS_FAL_MAC_ID_OUT_RANGE
//
// MessageText:
//
//  Invalid MAC ID entered in Init Stack request.
//
#define TLR_E_DNS_FAL_MAC_ID_OUT_RANGE   ((TLR_RESULT)0xC0620008L)

//
// MessageId: TLR_E_DNS_FAL_INVALID_PRODUCT_LEN
//
// MessageText:
//
//  Invalid Product Name Length entered in Init Stack request..
//
#define TLR_E_DNS_FAL_INVALID_PRODUCT_LEN ((TLR_RESULT)0xC0620009L)

//
// MessageId: TLR_E_DNS_FAL_INVALID_PRODUCED_SIZE
//
// MessageText:
//
//  Invalid Produced Size entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_PRODUCED_SIZE ((TLR_RESULT)0xC062000AL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_CONSUMED_SIZE
//
// MessageText:
//
//  Invalid Consumed Size entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_CONSUMED_SIZE ((TLR_RESULT)0xC062000BL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_MAJOR_REV
//
// MessageText:
//
//  Invalid Major Rev entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_MAJOR_REV  ((TLR_RESULT)0xC062000CL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_MINOR_REV
//
// MessageText:
//
//  Invalid Minor Rev entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_MINOR_REV  ((TLR_RESULT)0xC062000DL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_VENDOR_ID
//
// MessageText:
//
//  Invalid Vendor ID entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_VENDOR_ID  ((TLR_RESULT)0xC062000EL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_PRODUCT_TYPE
//
// MessageText:
//
//  Invalid Product Type entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_PRODUCT_TYPE ((TLR_RESULT)0xC062000FL)

//
// MessageId: TLR_E_DNS_FAL_INVALID_PRODUCT_CODE
//
// MessageText:
//
//  Invalid Product Code entered in Init Stack request.
//
#define TLR_E_DNS_FAL_INVALID_PRODUCT_CODE ((TLR_RESULT)0xC0620010L)

//
// MessageId: TLR_E_DNS_FAL_ALREADY_CONFIGURED
//
// MessageText:
//
//  Slave is already configured.
//
#define TLR_E_DNS_FAL_ALREADY_CONFIGURED ((TLR_RESULT)0xC0620011L)

//
// MessageId: TLR_E_DNS_FAL_SET_MODE_INVALID_MODE
//
// MessageText:
//
//  Invalid operation mode during Set Mode Request.
//
#define TLR_E_DNS_FAL_SET_MODE_INVALID_MODE ((TLR_RESULT)0xC0620012L)

//
// MessageId: TLR_E_DNS_FAL_SET_MODE_ALLREADY_IN_REQUEST
//
// MessageText:
//
//  Slave is currently in the mode requested.
//
#define TLR_E_DNS_FAL_SET_MODE_ALLREADY_IN_REQUEST ((TLR_RESULT)0xC0620013L)

//
// MessageId: TLR_E_DNS_FAL_GET_STATUS_INVALID_STATUS
//
// MessageText:
//
//  Invalid paramter in Get Status Command.
//
#define TLR_E_DNS_FAL_GET_STATUS_INVALID_STATUS ((TLR_RESULT)0xC0620014L)

//
// MessageId: TLR_E_DNS_FAL_UPDATE_IO_INVALID_IN_LEN
//
// MessageText:
//
//  Invalid Input Length specified in Update I/O Command.
//
#define TLR_E_DNS_FAL_UPDATE_IO_INVALID_IN_LEN ((TLR_RESULT)0xC0620015L)

//
// MessageId: TLR_E_DNS_FAL_UPDATE_IO_INVALID_OUT_LEN
//
// MessageText:
//
//  Invalid Output Length specified in Update I/O Command.
//
#define TLR_E_DNS_FAL_UPDATE_IO_INVALID_OUT_LEN ((TLR_RESULT)0xC0620016L)

//
// MessageId: TLR_E_DNS_FAL_UPDATE_IO_INVALID_OUT_OFFSET
//
// MessageText:
//
//  Invalid Output Offset specified in Update I/O Command.
//
#define TLR_E_DNS_FAL_UPDATE_IO_INVALID_OUT_OFFSET ((TLR_RESULT)0xC0620017L)

//
// MessageId: TLR_E_DNS_FAL_UPDATE_IO_INVALID_IN_OFFSET
//
// MessageText:
//
//  Invalid Input Offset specified in Update I/O Command.
//
#define TLR_E_DNS_FAL_UPDATE_IO_INVALID_IN_OFFSET ((TLR_RESULT)0xC0620018L)

//
// MessageId: TLR_E_DNS_FAL_SET_INPUT_INVALID_IN_LEN
//
// MessageText:
//
//  Invalid Input Length specified in Set Input Command.
//
#define TLR_E_DNS_FAL_SET_INPUT_INVALID_IN_LEN ((TLR_RESULT)0xC0620019L)

//
// MessageId: TLR_E_DNS_FAL_SET_INPUT_INVALID_IN_OFFSET
//
// MessageText:
//
//  Invalid Input Offset specified in Set Input Command.
//
#define TLR_E_DNS_FAL_SET_INPUT_INVALID_IN_OFFSET ((TLR_RESULT)0xC062001AL)

//
// MessageId: TLR_E_DNS_FAL_GET_OUTPUT_INVALID_OUT_LEN
//
// MessageText:
//
//  Invalid Output Length specified in Get Output Command.
//
#define TLR_E_DNS_FAL_GET_OUTPUT_INVALID_OUT_LEN ((TLR_RESULT)0xC062001BL)

//
// MessageId: TLR_E_DNS_FAL_GET_OUTPUT_INVALID_OUT_OFFSET
//
// MessageText:
//
//  Invalid Output Offset specified in Get Output Command.
//
#define TLR_E_DNS_FAL_GET_OUTPUT_INVALID_OUT_OFFSET ((TLR_RESULT)0xC062001CL)

//
// MessageId: TLR_E_DNS_FAL_DOWNLOAD_INVALID_AREA_CODE
//
// MessageText:
//
//  Invalid download area specified.
//
#define TLR_E_DNS_FAL_DOWNLOAD_INVALID_AREA_CODE ((TLR_RESULT)0xC062001EL)

//
// MessageId: TLR_E_DNS_FAL_DOWNLOAD_INVALID_SEQUENCE
//
// MessageText:
//
//  Invalid Download Sequence.
//
#define TLR_E_DNS_FAL_DOWNLOAD_INVALID_SEQUENCE ((TLR_RESULT)0xC062001FL)

//
// MessageId: TLR_E_DNS_FAL_DOWNLOAD_TO_MUCH_DATA
//
// MessageText:
//
//  To much data received.
//
#define TLR_E_DNS_FAL_DOWNLOAD_TO_MUCH_DATA ((TLR_RESULT)0xC0620020L)

//
// MessageId: TLR_E_DNS_FAL_DOWNLOAD_TO_LESS_DATA
//
// MessageText:
//
//  Not enough data received during the download.
//
#define TLR_E_DNS_FAL_DOWNLOAD_TO_LESS_DATA ((TLR_RESULT)0xC0620021L)

//
// MessageId: TLR_E_DNS_FAL_NO_CONFIGURATION
//
// MessageText:
//
//  No configuration.
//
#define TLR_E_DNS_FAL_NO_CONFIGURATION   ((TLR_RESULT)0xC0620022L)

//
// MessageId: TLR_E_DNS_FAL_BUS_OFF_STATE
//
// MessageText:
//
//  Network error BUS OFF detected.
//
#define TLR_E_DNS_FAL_BUS_OFF_STATE      ((TLR_RESULT)0xC0620023L)

//
// MessageId: TLR_E_DNS_FAL_NO_NETWORK
//
// MessageText:
//
//  No network access.
//
#define TLR_E_DNS_FAL_NO_NETWORK         ((TLR_RESULT)0xC0620024L)

//
// MessageId: TLR_E_DNS_FAL_BUS_STOP
//
// MessageText:
//
//  Communication not released by application (BUS Stop).
//
#define TLR_E_DNS_FAL_BUS_STOP           ((TLR_RESULT)0xC0620025L)

//
// MessageId: TLR_E_DNS_FAL_NO_COMMUNICATION
//
// MessageText:
//
//  No communication.
//
#define TLR_E_DNS_FAL_NO_COMMUNICATION   ((TLR_RESULT)0xC0620026L)

//
// MessageId: TLR_E_DNS_FAL_SERVICE_DATA_LENGTH_INVALID
//
// MessageText:
//
//  Invalid length of service data.
//
#define TLR_E_DNS_FAL_SERVICE_DATA_LENGTH_INVALID ((TLR_RESULT)0xC0620027L)

//
// MessageId: TLR_E_DNS_FAL_USER_OBJ_CONFIGURED
//
// MessageText:
//
//  User object already configured
//
#define TLR_E_DNS_FAL_USER_OBJ_CONFIGURED ((TLR_RESULT)0xC0620028L)

//
// MessageId: TLR_E_DNS_FAL_USER_OBJ_LOCKED
//
// MessageText:
//
//  User object is locked and can not be passed through
//
#define TLR_E_DNS_FAL_USER_OBJ_LOCKED ((TLR_RESULT)0xC0620029L)

//
// MessageId: TLR_E_DNS_FAL_USER_OBJ_ALREADY_REGISTERED
//
// MessageText:
//
//  User object has already been registered
//
#define TLR_E_DNS_FAL_USER_OBJ_ALREADY_REGISTERED ((TLR_RESULT)0xC062002AL)

//
// MessageId: TLR_E_DNS_FAL_USER_OBJ_NOT_REGISTERED
//
// MessageText:
//
//  User object has not been registered
//
#define TLR_E_DNS_FAL_USER_OBJ_NOT_REGISTERED ((TLR_RESULT)0xC062002BL)

//
// MessageId: TLR_E_DNS_FAL_24V_NETWORK_POWER_MISSING
//
// MessageText:
//
//  24V Network Power Missing
//
#define TLR_E_DNS_FAL_24V_NETWORK_POWER_MISSING ((TLR_RESULT)0xC062002CL)

//
// MessageId: TLR_E_DNS_FAL_UNRECOVERABLE_FAULT
//
// MessageText:
//
// Unrecoverable Major Fault
//
#define TLR_E_DNS_FAL_UNRECOVERABLE_FAULT ((TLR_RESULT)0xC062002DL)

#endif  //__DNS_FAL_ERROR_H
